#!/usr/bin/perl

use Module::Build;

my $builder = Module::Build->subclass(
    class => 'My::Module::Build',
    code => <<'___CODE',
    use strict;
    use warnings;
    use File::Temp;
    sub ACTION_equivs {
        my $self = shift;
        my %provides = (
            'POSIX' => 'perl-base',
            'File::Path' => 'perl-modules',
        );
        my %deps = ( ( map { (my $d = $_ ) =~ s/::/-/g;
             defined $provides{$_} ? $provides{$_} : 'lib' . lc $d . '-perl'
               => $self->requires->{$_} == 0 ? '' : ' (>= ' . $self->requires->{$_} . ')' 
             } keys %{$self->requires} ),
         'at' => ''
        );
        my $c = new File::Temp or die "Can't tempfile";
        print $c "Package: libius-dav-htpasswd-perl-deps\n";
        print $c 'Depends: ', join ', ', map { "$_$deps{$_}" } keys %deps;
        system('equivs-build', $c->filename);
    }
___CODE
);

my $build = $builder->new
(
    module_name => 'Ius::Dav::Htpasswd',
    license  => 'gpl',
    create_license => 1,
    requires => {
        'Apache::Htpasswd' => 0,
        'AppConfig' => 0,
        'File::Path' => 0,
        'POSIX' => 0,
        'String::MkPasswd' => 0
    },
    script_files => [glob 'bin/*'],
    cgi_files => { map { /\.(bak|orig)$/ ? () : ($_ => $_) } glob 'cgi-bin/admin/*' }
);
$build->add_build_element('cgi');
$build->install_path(
    'cgi-bin' => $build->original_prefix($build->installdirs) . '/lib/cgi-bin');
$build->create_build_script;
