#!/usr/bin/perl

#    Copyright (C) 2011  Matthias Förste
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#    Matthias Förste <foerste@schlittermann.de>

use warnings;

#use CGI::Fast;
#use POSIX;

while (my $q = new CGI::Fast) {

    print $q->header(-charset => 'UTF-8');
    print $q->start_html(
        -title   => $0,
        -bgcolor => "white",
    );

    my ($user, $expiry) = (
        $q->param('user'),
        $q->param('expiry')
    );

    print $q->start_form, 'New User' => $q->textfield('user'), 'Expiry' => $q->textfield('expiry'), $q->submit, $q->end_form
        unless defined $user or defined $expiry;

    $expiry ||= $defaults->{expiry};
    if (_validate $q, $user, $expiry) {

        my $t = POSIX::strftime '%Y%m%d%H%M%S', time + 86400 * $expiry;
        my @at_cmd = ('at', $t


    } else {
        _error ($q, 'invalid input');
    }

    print $q->end_html;

}

sub _validate {

    my ($u, $e) = @_;

    return unless $u =~ /^[[:alpha:]_]+$/; 
    return unless $e =~ /^[0-9]+$/;
    return unless $e >= $defaults->{expiry_min} and $e <= $defaults->{expiry_max};

    return 1;

}

sub _notice {

    my ($q, @n) = @_;
    print @_;

}

sub _error {

    my ($q, @n) = @_;
    print @_;

}
