#!/usr/bin/perl

#    Copyright (C) 2011  Matthias Förste
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#    Matthias Förste <foerste@schlittermann.de>

use warnings;

# Using CGI::Fast will result in an Internal Server Error because we are
# restarting apache when everything else works
# use CGI::Fast;
use CGI;
use Ius::Dav::Htpasswd qw(mkpasswd readconfig useradd);

my $q = new CGI;

    print $q->header(-charset => 'UTF-8');
    print $q->start_html(
        -title   => $0,
        -bgcolor => "white",
    );

    my ($user, $pass, $expiry) = (
        $q->param('user'),
        $q->param('pass'),
        $q->param('expiry')
    );

    unless (defined $user or defined $pass or defined $expiry) {

        print $q->start_form,
            'New User' => $q->textfield('user'),
            'Password' => $q->password_field('pass'),
            'Expiry' => $q->textfield('expiry'),
            $q->submit,
            $q->end_form;

    } else {

        my @cmd = (qw(sudo dav-htuseradd -u), $user);
        push @cmd, '-e', $expiry if defined $expiry and $expiry ne ''; 

        if (my $pass = qx(@cmd)) {
            chomp $pass;
            print $q->p($pass);
        } else {
            print $q->p('Something went wrong');
        } 

    }

    print $q->end_html;
