#!/usr/bin/perl
# dieses script checkt die Anzahl virtueller Hosts und Mailadressen
# pro Kunde für die Abrechnung
# schlorke;
#

use warnings;
use strict;
use Config::IniFiles;
use CGI qw/:standard *table/;
use CGI::Carp qw/fatalsToBrowser/;
use CGI::Pretty;
use Cwd;
use DBI;

# Damit -T nicht mault
delete @ENV{grep /PATH/, keys %ENV};
$ENV{PATH} = "/usr/sbin:/sbin:/usr/bin:/bin";

my $real_uid = $<;
my $ME = url( -relative => 1 );
my $config_file = "acc.conf";
my $cfg         = new Config::IniFiles( -file => "$config_file" );

my $DBH;
my $section     = "database";
my $db_server   = $cfg->val( $section, "server" );
my $db_name     = $cfg->val( $section, "name" );
my $db_user     = $cfg->val( $section, "user" );
my $db_password = $cfg->val( $section, "password" );

my $domain;

sub getRoot();
sub releaseRoot();

my $mx;

MAIN: {
    $section = "main";
    my $title = $cfg->val( $section, "title" );
    my $style = $cfg->val( $section, "style" );

    my %err = ();


    print header( -charset => "utf-8" ),
        start_html(
	    -encoding => "utf-8",
	    -title    => $title,
	    -author   => "Grit Schlorke <schlorke\@schlittermann.de>",
	    -meta     => {
		"copyright" =>
		    "copyright 2008 Schlittermann - internet & unix support"
	    },
	    -style => $style
	);


    #
    # Formular
    #
    {

    map { $err{$_} = div { class => "Err" }, "[$err{$_}]" } keys %err;

    print div( { -id => "main_title" }, $title );

    print div(
	{ -id => "content" },
	start_form(),
	"Domain:",
	textfield(  
	    -name => "domain",
	    -size => 40,
	),
	submit(
	    -class =>"button",
	    -name => "show",
	    -value => "anzeigen"
	),
	end_form()
    );

    }

    if (param("show")) {
	$domain = param("domain");

	# Webhosting
	
	getRoot();
	my $web = "nein";
	my $dirname = "/etc/apache2/sites-enabled";
	
	opendir (DIR, $dirname) or die "Can't open directory: \"$dirname\": $!\n$<\n";
	my $file;
	my $test = "www.$domain";
	
	while (defined ($file = readdir(DIR))) {
	    open (F1, "<$dirname/$file") || die "Can't open file: \"$file\": $!\n";
		while (<F1>) {
		    if ($file eq $test) {
			if (/^\s*Redirect\s\/\s(.*)/) {
			    $web = "Redirect nach $1";
			    last;
			}
			if (/^\s*DocumentRoot.*?$domain/) {
			    $web = "ja";	
			}
		    }
		    else {
			if (/^\s*ServerAlias\s(.*)/) {
			    if ($1 eq $test) {
				$web = "Alias für $file";
			    }
			}
		    }
			
		}
	}
	releaseRoot();

	print "<div id=\"content\">", start_form(),
	    start_table( { -border => "0", -width => "50%" } ),
	    Tr(
	    th( { -id => "view", -align => "left" }, "Webhosting"),
	    );
		print Tr(
		    td( { -id => "view", -align => "left" }, $web),
		);
	print end_table(), end_form(), "</div>";


	# Mail-Accounts + Anzahl
	my $request;
	($domain =~ /\s*([a-z\d-.]+)/) and $domain = $1;
	($request = `host -t MX $domain`);
	if ($request =~ /ssl.schlittermann.de/i) {
	    $mx = "ja";
	}
	else {
	    $mx = "nein";
	}

	my $count;
	my $dbh;
	$dbh = DBI->connect("DBI:mysql:$db_name:$db_server", "$db_user", "$db_password",
	    { RaiseError => 0, PrintError => 0, AutoCommit => 0 } )
	    or print div( { -class => "error" }, "$DBI::errstr" )
	    and exit 0;
	
	my $sth = $dbh->prepare("SELECT id, user FROM users WHERE domain='$domain'");
	my $sth2 = $dbh->prepare("SELECT COUNT(*) FROM users WHERE domain='$domain'");

	$sth->execute()
	    or print div( { -class => "error" }, "$DBI::errstr" )
	    and exit 0;
	
	$sth2->execute()
	    or print div( { -class => "error" }, "$DBI::errstr" )
	    and exit 0;
	$count = $sth2->fetchrow_array();
	
	print "<div id=\"content\">", start_form(),
	    start_table( { -border => "0", -width => "50%" } ),
	    Tr(
	    th( { -id => "view", -align => "left" }, "MX"),
	    );
		print Tr(
		    td( { -id => "view", -align => "left" }, $mx),
		);
	print end_table(), end_form(), "</div>";

	print "<div id=\"content\">", start_form(),	    
	    start_table( { -border => "0", -width => "50%" } ),
	    Tr(
	    th( { -id => "view", -align => "left" }, "Mail-Accounts"),
	    );
	    my $line = 0;
	    while ( my $row = $sth->fetchrow_arrayref() ) {
		my (
		    $id, $user
		) = @$row;
		
		print Tr(
		    td( { -id => "view", -align => "left" }, "$user\@$domain" ),
		);
	}
	
	print end_table(), end_form(), "</div>";

        print "<div id=\"content\">", start_form(),
            start_table( { -border => "0", -width => "50%" } ),
            Tr(
            th( { -id => "view", -align => "left" }, "Mail-Accounts gesamt"),
            );
                print Tr(
                    td( { -id => "view", -align => "left" }, $count),
                );
        print end_table(), end_form(), "</div>";

    }

    print end_html();
}


sub getRoot() { $< = 0; }
sub releaseRoot() { $< = $real_uid; }


sub read_db() {
    my %LIST;
    my $dbh;
    END { $dbh->disconnect() if $dbh; }

    $dbh = DBI->connect("DBI:mysql:$db_name:$db_server", "$db_user", "$db_password",
        { RaiseError => 1 });

    my $sth = $dbh->prepare("SELECT id, user FROM users WHERE domain='$domain'");

    $sth->execute();

    while (my $users = $sth->fetchrow_arrayref()) {
        my ($id, $user) = @{$users};
        $LIST{$id} = $user;
    }
    return %LIST;

}


# vim:sts=4 sw=4 ai aw sm:

