use 5.010;
use strict;
use warnings;
use autodie qw(:all);
use Test::More;
use Sys::Hostname;

use constant SIZE => 27 * 1024 * 1024;

use File::Temp;

my $err = File::Temp->new;
my $dir = File::Temp->newdir;

note("preparing the source");
open(my $out, "+>$dir/source");
print $out rand while -s $out < SIZE;

note("preparing the images dir");
mkdir "$dir/images";
mkdir "$dir/mnt";

system("sudo mount -ttmpfs -osize=10M,uid=$> tmpfs $dir/mnt 2>/dev/null");
END { system("sudo umount $dir/mnt 2>/dev/null") };


system("perl -Mblib blib/script/imager.save $dir/source:source $dir/images");
is($? => 0, "saved");

system("perl -Mblib blib/script/imager.restore $dir/images/idx/@{[hostname]}/source/* $dir/source.restored");
is($? => 0, "restored");

# just as it is
seek($out, 0, 0);
open(my $restored, "$dir/source.restored");
ok(<$out> ~~ <$restored>, "source === restored");

# now compress and check again
system("perl -Mblib blib/script/imager.compress $dir/images 2>$err");
system("perl -Mblib blib/script/imager.restore $dir/images/idx/@{[hostname]}/source/* $dir/source.restored");
is($? => 0, "restored") or do { seek $err => 0, 0; diag <$err> };
seek($out, 0, 0);
open($restored, "$dir/source.restored");
ok(<$out> ~~ <$restored>, "compressed source === restored");

# now check on overflow of destination

note("overflow condition");
eval { system("perl -Mblib blib/script/imager.save $dir/source:source $dir/mnt 2>$err") };
ok($?, "failure is expected");


done_testing;
