package Imager;
use 5.010;
use strict;
use warnings;
use IO::Uncompress::Gunzip qw(gunzip $GunzipError);
use autodie qw(:all);

use constant CIPHER => "aes-128-cbc";

sub get_block {
    my ($file, $buffer) = @_;

    given ($file) {
        when (/\.gz\.x$/) {
            open(my $fh => "openssl @{[CIPHER]} -d -pass $::o{pass} -in $file|");
            local $/ = undef;
            gunzip($fh => $buffer) or die $GunzipError;
        }
        when (/\.gz$/) { gunzip($file => $buffer) or die $GunzipError }
        when (/\.x$/) {
            open(my $fh => "openssl @{[CIPHER]} -d -pass $::o{pass} -in $file|");
            local $/ = undef;
            $$buffer = <$fh>;
        }
        default { open(my $fh => $file); local $/ = undef; $$buffer = <$fh> }
    }
}

1;
