#!/usr/bin/perl
use 5.010;
use strict;
use warnings;
use Crypt::CBC;
use autodie qw(:all);
use Benchmark qw(:all);
use File::Temp;

my $tmp = File::Temp->new();

{ 
    open(my $fh, "/dev/urandom");
    local $/ = \(my $x = 1024 * 1024);	# 1 MiB
    for (1 .. 4) {
	print {$tmp} scalar <$fh>;
    }
}

sub getbyref {
    my $ref = shift;
    local $/ = undef;
    seek($tmp, 0, 0);
    $$ref = <$tmp>;
}

sub getbyval {
    seek($tmp, 0, 0);
    local $/ = undef;
    return <$tmp>;
}

cmpthese(900 => {
    byref => sub { my $x; getbyref(\$x); $_ = length($x) },
    byval => sub { my $x = getbyval(); $_ = length($x) },
    }
);



__END__



cmpthese(30 => {
    'openssl' => sub { openssl($text) },
    'perlssl' => sub { perlssl($text) },
    }
);

cmpthese(30 => {
    'gzip' => sub { bingzip($text) },
    'perlzip' => sub { perlzip($text) },
    }
);

sub openssl {
    open(my $out, "|openssl bf -pass env:X -out $tmp") or die;
    print $out $_[0];
    close $out;
    die $? if $?;
}

sub perlssl {
    open(my $out, ">$tmp");
    print $out $cipher0->encrypt($_[0]);
    close $out;
}

sub perlzip {
    open(my $out, ">$tmp");
    gzip($_[0] => $out);
}

sub bingzip {
    open(my $out, "|gzip -1 >$tmp");
    print $out $_[0];
    close $out;
    die $? if $?
}
