#!/usr/bin/perl
use 5.010;
use strict;
use warnings;
use Crypt::CBC;
use autodie qw(:all);
use Benchmark qw(:all);
use IO::Compress::Gzip qw(gzip $GzipError);
use File::Temp;

my $tmp = File::Temp->new();
warn "<< $tmp >>\n";

my $cipher0 = Crypt::CBC->new(
    -key => "x",
    -keysize => 16,
    -cipher => 'Blowfish',
) or die;
$ENV{X} = "x";

@ARGV = qw(/boot/vmlinuz-2.6.32-5-amd64);
my $text = join "" => <>;

say length $text;

cmpthese(30 => {
    'openssl' => sub { openssl($text) },
    'perlssl' => sub { perlssl($text) },
    }
);

cmpthese(30 => {
    'gzip' => sub { bingzip($text) },
    'perlzip' => sub { perlzip($text) },
    }
);

sub openssl {
    open(my $out, "|openssl bf -pass env:X -out $tmp") or die;
    print $out $_[0];
    close $out;
    die $? if $?;
}

sub perlssl {
    open(my $out, ">$tmp");
    print $out $cipher0->encrypt($_[0]);
    close $out;
}

sub perlzip {
    open(my $out, ">$tmp");
    gzip($_[0] => $out);
}

sub bingzip {
    open(my $out, "|gzip -1 >$tmp");
    print $out $_[0];
    close $out;
    die $? if $?
}
