use 5.010;
use strict;
use warnings;
use Test::More;
use File::Find;
use File::Temp;

my @files;
find(sub {
	-f -x or return;
	push @files => $File::Find::name;
}, "bin");

plan tests => scalar @files;

my $tmp = File::Temp->new;

foreach (@files) {
	system("perl -c $_ 2>$tmp");
	seek($tmp, 0, 0);
	is($? => 0, "syntax $_ OK") or diag join "" => <$tmp>;
}
