package Exim;

use strict;
use warnings;
use Carp;

my %basename;
my %binary;
my %config;

sub new {
    my $class = ref $_[0] ? ref shift : shift;

    bless my $self = \my $anonymous => $class;
    my %arg = @_;

    $basename{$self} = $arg{basename} ? $arg{basename} : "exim4";
    $config{$self}   = $arg{config}   ? $arg{config}   : "$arg{basename}.conf";
    $binary{$self} = $self->_find_exim;

    return $self;
}

sub binary {
    my $self = shift;
    return $binary{$self};
}

sub run {
    my $self = shift;
    return qx/$binary{$self} -C $config{$self} @_/;
}

sub get {
    my $self = shift;
    chomp(local $_ = $self->run(-bP => shift));
    croak $_ unless /=/;
    return /=\s*(.*)/;
}

sub DESTROY {
    my $self = shift;
    delete $basename{$self};
    delete $binary{$self};
    delete $config{$self};
}

sub _find_exim {
    my $self = shift;
    my %seen;
    foreach (split /:/, "$ENV{PATH}:/usr/local/sbin:/usr/sbin:/sbin") {
        next if $seen{$_};
        return "$_/$basename{$self}" if -x "$_/$basename{$self}";
    }
    croak "Can't find the exim binary ($basename{$self})\n";
}

1;
