use Test::More;
use Test::MTA::Exim4;
use Data::Dumper;


my @TESTS = (
    [
        'hans@foo.de' => {
            transport => 'remote_smtp_submission',
            router    => 'smart_smtp',
        }
    ],
    [
        'heiko@localhost' => {
            transport => 'local_delivery',
            router    => 'localuser',
        },
    ],
);


my $exim = Test::MTA::Exim4->new;
#diag Dumper $exim->_run_exim_bt('hans@localhost');

cmp_ok $exim->exim_version, '>=', 4 => 'Version ok';
$exim->config_ok;


$exim->routes_as_ok(@$_) foreach @TESTS;

done_testing;
