#! perl

use Test::More;
use strict;
use warnings;

use_ok 'DNS::Vi' or BAIL_OUT 'DNS::Vi not found!';
can_ok 'DNS::Vi', qw(ttl2h h2ttl parse nice delta edit update show);

# TODO: more tests!
is ttl2h(86400), '1d',  '-> 1d';
is h2ttl('1d'),  86400, '<- 1d';

my $data1 = do {
    local $/    = undef;
    local @ARGV = 't/samples/kugelbus-axfr';
    <>;
};

# check parser with and without skip list
is parse($data1), 64 => '64 rrsets';
my @zone1 =
  parse($data1, { -skip => [qw(RRSIG NSEC3 NSEC3PARAM NSEC DNSKEY TSIG)] });
is @zone1, 18 => '18 rrsets';

subtest 'parsed data' => sub {
    my ($soa) =
      map { $_->{rrset} } grep { $_->{rrset}{rrtype} eq 'SOA' } @zone1;
    is ref $soa, 'HASH' => 'got result hash';
    is $soa->{rrtype}, 'SOA' => 'is SOA';
    is $soa->{data},
        'pu.schlittermann.de. '
      . 'hostmaster.net.schlittermann.de. '
      . '18 86400 7200 604800 86400' => 'has expected data';

    my @txt = map { $_->{rrset} } grep { $_->{rrset}{rrtype} eq 'TXT' } @zone1;
    is @txt, 3 => 'got 3 txt records';
};

# delta should find noting
subtest 'delta' => sub { 
    my ($add, $del) = delta(\@zone1, \@zone1);
    is @$add, 0 => 'nothing added';
    is @$del, 0 => 'nothing deleted';
};

done_testing();
