#! perl

use Test::More;
use strict;
use warnings;

use_ok 'DNS::Vi' or BAIL_OUT 'DNS::Vi not found!';
can_ok 'DNS::Vi', qw(ttl2h h2ttl parse nice delta);

# TODO: more tests!
is ttl2h(86400), '1d',  '-> 1d';
is h2ttl('1d'),  86400, '<- 1d';

my $data = do {
    local $/    = undef;
    local @ARGV = 't/samples/kugelbus-axfr';
    <>;
};

my @zone1 = parse($data);
is @zone1, 64 => '64 rrsets';

$data =~ s{^kugelbus.*?IN\s+MX.*?$}{}m;
$data .= <<_;
foo 1h	txt "foo"
    30m	A   1.1.1.1
_
my @zone2 = parse($data);
is @zone2, 65, => '65 rrsets';

my ($add, $del) = delta(\@zone1, \@zone2);
is @$add, 2 => '2 sets to add';
is @$del, 1 => '1 set to delete';

is_deeply $add,
  ['foo.kugelbus.de. 1800 A 1.1.1.1', 'foo.kugelbus.de. 3600 TXT "foo"'] =>
  'added datasets';
is_deeply $del,
  ['kugelbus.de. 86400 MX 10 ssl.schlittermann.de.'] => 'removed datasets';

done_testing();
