#! perl
use strict;
use warnings;
use Test::More;
use DNS::Vi;

sub slurp {
    local @ARGV = @_;
    join "\n", <>;
}

ok my @zone1 = parse(slurp 't/samples/frey-1') => 'got 1st zone';
ok my @zone2 = parse(slurp 't/samples/frey-2') => 'got 2nd zone';;

ok my %delta = delta(\@zone1, \@zone2) => 'got delta';
is @{$delta{add}}, 2 => '2 added';
is @{$delta{del}}, 3 => '3 deleted';


done_testing;
