#! perl

use 5.010;
use Test::More;
use strict;
use warnings;
use File::Basename;

use_ok 'DNS::Vi' or BAIL_OUT 'DNS::Vi not found!';
can_ok 'DNS::Vi', qw(ttl2h h2ttl parse nice delta edit update show);

# TODO: more tests!
is ttl2h(86400), '1d',  '-> 1d';
is h2ttl('1d'),  86400, '<- 1d';

sub slurp {
    local $/ = undef;
    open(my $x, '<', shift);
    return <$x>;
}

# the results must match the t/samples/? files
my %result = (
    axfr => {
        RRSETS => 64,
        SOA    => 1,
        NS     => 2,
        A      => 6,
        TXT    => 3,
        AAAA   => 1,
        MX     => 5,
    },
    a => {
        RRSETS => 32,
        SOA    => 1,
        NS     => 16,
        A      => 9,
        TXT    => 4,
        AAAA   => 0,
        MX     => 0,
    },
    b => {
        RRSETS => 7,
        SOA    => 1,
        NS     => 2,
        A      => 1,
        TXT    => 3,
        AAAA   => 0,
        MX     => 0,
    },
    c => {
        RRSETS => 12,
        SOA    => 1,
        NS     => 2,
        A      => 2,
        TXT    => 5,
        AAAA   => 0,
        MX     => 2,
    },
);

# uniq list of rrtypes we want to test
my @sets = do {
    my %h;
    @h{ map { keys %{$_} } values %result } = ();
    grep { $_ ne 'RRSETS' } sort keys %h;
};

foreach my $sample (sort keys %result) {
    my $file = "t/samples/$sample";

    subtest "sample $file" => sub {
        my %result = %{ $result{$sample} };
        my @zone   = parse(slurp $file);
        is @zone, $result{RRSETS} => "$sample: $result{RRSETS} RRSETS";
        foreach my $type (@sets) {
            is grep({ $_->{rrset}{rrtype} eq $type } @zone),
              $result{$type} => "$sample: $result{$type} $type";
        }

        my ($added, $deleted) = delta(\@zone, \@zone);
        is @$added,   0 => 'nothing added';
        is @$deleted, 0 => 'nothing deleted';
      }
}

done_testing();
