use strict;
use warnings;
use Test::More;
use English qw(-no_match_vars);
use File::Temp;
use File::Basename;
use File::Find;
use Cwd qw(abs_path);
use POSIX qw(SEEK_END);
use Digest::MD5;

plan skip_all => "Need root permissions to perform these tests.\n"
    . "\t try: sudo ./Build test verbose=1 test-files=$0"
    if not $EUID == 0;

my $dir = File::Temp->newdir(TEMPLATE => "blockfuse.XXXXXX");

END { system("umount $dir 2>/dev/null") if $dir };
system("blib/script/blockfuse $dir");
is($?, 0, "mounted");

my %size;
find(sub {
    (my $name = $File::Find::name) =~ s/^\/dev//;
    if (-d) {
	ok(-d "$dir/$name", "dir $name");
    }
    elsif (-b) {
	ok(-f "$dir/$name", "block->file $name");
	if (open(my $block, $_)) {
	    seek($block, 0, SEEK_END);
	    my $size = tell($block);
	    close($block);
	    is($size, -s "$dir/$name", "size $name");
	    $size{$name} = $size;
	}
    }
    elsif (-l and (-b abs_path $_ or -d abs_path $_)) {
	ok(-l "$dir/$name", "link $name");
    }
}, "/dev");

# now md5sum test for the smallest device
my $smallest = (sort { $size{$a} <=> $size{$b} } grep {$size{$_}} keys %size)[0];
$smallest =~ s/^\///;


my %digest = (
    dev => Digest::MD5->new(),
    file => Digest::MD5->new(),
);

note "checking digests of $smallest";
{
    local $/ = \4096;
    open(my $dev, "/dev/$smallest") or die "/dev/$smallest: $!";
    $digest{dev}->add($_) while defined($_ = <$dev>);

    open(my $file, "$dir/$smallest") or die "$dir/$smallest: $!";
    $digest{file}->add($_) while defined($_ = <$file>);
}

is($digest{file}->hexdigest(), $digest{dev}->hexdigest(), "digests of $smallest are equal");



done_testing();
