use 5.010;
use strict;
use warnings;
use Test::More;
use File::Find;
use File::Temp;

my @files;
find(sub {
    -f -x and ~/^\./ or return;
    push @files, $File::Find::name;
}, "blib");

plan tests => scalar @files;

my $tmp = File::Temp->new();
foreach my $file (@files) {
    system("perl -c $file 1>$tmp 2>&1");
    is($? => 0, "syntax $file is ok")
	or do { seek $tmp, 0, 0;
	        diag <$tmp> };

}
