use strict;
use warnings;
use Test::More;

use_ok "Message::2822"
    or BAIL_OUT "Can't load the Message::2822 module";

my $file = "ex/mails/unsigned";

# the object itself
my $message = Message::2822->new(file => $file);
isa_ok($message => "Message::2822");

# the complete header, we need it for later verification 
# as well
my @header_lines = split /\n/ => $message->orig_header();
ok(scalar(@header_lines), "got some header lines");

my $received = grep /^received:/i => @header_lines;
my @received0 = $message->header_content("received:");
my @received1 = $message->header_content("Received:");

is(scalar(@received0), $received, "$received received headers");
is_deeply(\@received0, \@received1, "case insensitive field names");


done_testing();
