package Message::2822;

use 5.010;
use strict;
use warnings;
use IO::File;
use if $ENV{DEBUG} => "Smart::Comments";

my %DATA;

sub new {
    my $class = ref $_[0] ? ref shift : shift;
    my $this = bless \(my $x) => $class;
    my %arg = @_;

    $DATA{$this}{file} = $arg{file};
    $DATA{$this}{fh} = IO::File->new($DATA{$this}{file})
	or die "Can't open $DATA{$this}{file}: $!\n";

    local $/ = "";
    my $_ = $DATA{$this}{fh}->getline();

    foreach (split /\n(?=\S)/, $_) {
	my (undef, $k, $v) = split /(^(?:\S+:|(?i:from )))/, $_;
	push @{$DATA{$this}{header_fields}}, $k;
	$DATA{$this}{header}{$k} = $v;
    }

    return $this;
}

sub header_fields {
    my $this = shift;
    return @{$DATA{$this}{header_fields}};
}

sub header_content {
    my $this = shift;
    my $field = shift;

    my $_ = $DATA{$this}{header}{$field};

    if (not defined) {
	($field) = grep /^$field$/i => $this->header_fields();
	$_ = $DATA{$this}{header}{$field}
    }

    /^\s*(.*?)\s*$/m;
    return $1;
}

sub DESTROY {
    my $this = shift;
    delete $DATA{$this};
}


1;
