use strict;
use warnings;
use Test::More;

use_ok "Message::2822"
  or BAIL_OUT "Can't load the Message::2822 module";

my @files = glob("ex/mails/*");
cmp_ok(@files, ">", 1, "more then 1 test message");
can_ok("Message::2822", qw(new));

my %message;
foreach my $file (@files) {
    my $msg = Message::2822->new(file => $file);
    isa_ok($msg, "Message::2822", "object is Message::2822 ($file)");
    $message{$file} = $msg;
}

# check if we really get all header fields
foreach my $file (keys %message) {

    # get a sorted list of header fields
    open(my $f, $file) or die "Can't open $file: $!\n";
    $/ = "";
    $_ = <$f>;
    my @h = sort /^(\S+?[ :])/mg;

    is_deeply([sort $message{$file}->header_fields()], \@h,
        "all header fields");

    is_deeply(
        [sort $message{$file}->header_fields('^f')],
        [grep /^f/i => @h],
        "partial header fields '^f'"
    );

    is_deeply(
        [sort $message{$file}->header_fields(qr/^f/i)],
        [grep /^f/i => @h],
        "partial header fields qr/^f/i"
    );
}

done_testing;
__END__

# the object itself
my $message = Message::2822->new(file => $file);
isa_ok($message => "Message::2822");

# the complete header, we need it for later verification 
# as well
my @header_lines = split /\n/ => $message->orig_header();
ok(scalar(@header_lines), "got some header lines");

my $received = grep /^received:/i => @header_lines;
my @received0 = $message->header_contents("received:");
my @received1 = $message->header_contents("Received:");
my $received0 = $message->header_contents("received:");  # single lines

is(scalar(@received0), $received, "$received received headers in list");
is(scalar(@received0), scalar(my @a = $received0 =~ /\n/g), "$received received lines in scalar");
is_deeply(\@received0, \@received1, "case insensitive field names");

done_testing();
