package Debian::DebFile; 

use strict;
use warnings;
use File::Basename;

use Carp;

sub new {
    my $class = ref $_[0] ? ref shift : shift;
    my $self = {}; bless $self, $class;

    # Wenn wir mit einer Referenz auf ein Debian::File initialisiert
    # werden, dann können wir den prefix von fort übernehmen -- so 
    # haben wir dann in {file} den richtigen 

    if (ref($_[0]) eq "Debian::File") {
	$self->{file} = $_[0]->file;
	$self->{prefix} = $_[0]->prefix;
    } else {
	$self->{file} = basename($_[0]);
	$self->{prefix} = dirname($_[0]);
    }

    $self->{path} = join "/", @{$self}{qw/prefix file/};

    shift;

    $self->parse;

    return $self;
}

sub file { $_[0]->{file} }
sub prefix { $_[0]->{prefix} }

sub parse {
    my $self = shift;

    my $key;
    foreach (`dpkg --info $self->{path}`) {
	s/^\s//;

	defined $key and /^\s+(\S.*)/ and do {
	    push @{$self->{deb}{$key}}, $1;
	    next;
	};

	/^(\S+):(?:\s+(.*))?/ and do {
	    $key = lc($1);
	    push @{$self->{deb}{$key}}, $2 if defined $2;
	    next;
	};

    }
}

sub key {
    my $self = shift;
    my $key = shift;

    return @{$self->{deb}{$key}} if wantarray;
    return join "\n", @{$self->{deb}{$key}};
}


1;
# vim:sts=4 sw=4 aw ai sm:
