package Debian::Repository;

use strict;
use warnings;

use File::Path;

sub new {
    my $class = ref $_[0] ? ref shift : shift;
    my $self = bless {}, $class;

    $self->{vars} = shift;

    return $self;
}

sub origin { $_[0]->{vars}{origin} }
sub dists { $_[0]->{vars}{dists} }
sub sections { $_[0]->{vars}{sections} }
sub binary { $_[0]->{vars}{binary} }
sub source { $_[0]->{vars}{source} }
sub root { $_[0]->{vars}{root} }

sub checkDirs {
    my $self = shift;

    my %args = @_;

    $args{create} ||= 0;
    $args{umask} ||= umask;

    my $root = $self->root;
    my $dists = $self->dists;
    my $sections = $self->sections;
    my $binary = $self->binary;
    my $source =$self->source;
    my $origin = $self->origin;

    my (@dirs, @archdirs);
    push @dirs, "$root/pool";
    foreach my $dir (map { "$root/dists/$_" } @$dists) {
	push @dirs, $dir;
	foreach my $section (@$sections) {
	    push @dirs, "$dir/$section";
	    foreach my $arch (@$binary) {
		push @dirs, "$dir/$section/binary-$arch";
		push @archdirs, { dir => $dirs[-1], arch => $arch };
	    }
	    foreach my $arch (@$source) {
		push @dirs, "$dir/$section/$arch";
		push @archdirs, { dir => $dirs[-1], arch => $arch };
	    }
	}
    }

    # create dirs
    if ($args{create}) {
	my $mask = umask($args{umask});
	foreach (@dirs) {
	    -d $_ or mkdir($_) or die "Can't mkdir $_: $!\n";
	}

	# create relases files
	foreach my $dist (@$dists) {
	    #foreach my $dir ("$root/dists/$dist", @archdirs) {
	    foreach my $d (@archdirs) {
		my ($dir, $arch);
		if (ref $d eq "HASH") {
		    $arch = $d->{arch};
		    $dir = $d->{dir};
		} else { $dir = $d }

		$_ = "$dir/Release";
		my $r = new IO::File ">$_" or die "Can't open >$_: $!\n";
		$r->print(<<___);
Release: $dist
Suite: $dist
Origin: $origin
___
		$r->print("Architecture: $arch\n") if defined $arch;
	    }
	}
	umask($mask);
    }
}

1;

# vim:sts=4 sw=4 aw ai sm:
