package Debian::Pool;

use strict;
use warnings;
use Carp;

sub new {
    my $class = ref $_[0] ? ref shift : shift;
    my $self = {};

    my %args = @_;

    $self->{archs} = @{$args->{archs}};
    $self->{root} = $args->{root};

    bless $self, $class;
}

sub getRoot { $_[0]->{root} }
sub getArchs { $_[0]->{archs} }
sub getBinArchs { grep !/^source$/, $_[0]->{archs} }
sub getSrcArchs { grep /^source$/, $_[0]->{archs} }

1;

# vim:sts=4 sw=4 aw ai sm:
