package Debian::File;

use strict;
use warnings;

use IO::File;
use Digest::MD5;
use Carp;

sub new {
    my $class = ref $_[0] ? ref shift : shift;
    my $self = bless {}, $class;
    my $description = shift;
    my %args = @_;

    @{$self}{keys %args} = values %args;

    foreach my $a (qw/prefix current_prefix/) {
	$self->{$a} =~ s/\/$//;
    }

    my @fields = split " ", $description;

    if (@fields == 5) {
	@{$self}{qw/md5 size section part file/} = @fields;
    } elsif (@fields == 3) {
	@{$self}{qw/md5 size file/} = @fields;
    } else {
	croak "Unknown format: $_\n";
    }

    $self->check;   # will croak
    return $self;
}

sub md5 { $_[0]->{md5} }
sub size { $_[0]->{size} }
sub section { $_[0]->{section} }
sub part { $_[0]->{part} }
sub file { $_[0]->{file} }
sub prefix { $_[0]->{prefix} }
sub path { join "/", @{$_[0]}{qw/prefix file/} }
sub component { $_[0] =~ /^(.*?)\// ? $1 : "main" }

sub check {
    my $self = shift;


    my $file = join "/", $self->{current_prefix} ? $self->{current_prefix} : $self->{prefix}, $self->file;
    my $size = $self->size;
    my $md5 = $self->md5;

    croak "File does not exist: $file\n"  if !-f $file;
    croak "Size mismatch: $file (" . (-s _) . " != $size)\n" if not $size == (-s _);

    my $digest = new Digest::MD5;
    my $fh = new IO::File $file or croak "Can't open <$file: $!\n";
    $digest->addfile($fh);

    croak "MD5 mismatch: $file\n" if not $digest->hexdigest eq $md5;
}

1;

# vim:sts=4 sw=4 aw ai sm:
